#load the needed libriaries
library(SparseM)
library(PolynomF)
library(modelfree)
library(psyphy)

##fitting the individual psychometric function
#input the data
pseData <- read.table("__.txt", header=TRUE)
b <- pseData$h #ipRGC High condition, or blue 
r <- pseData$c #control condition, or red 
t <- pseData$f #Lightflux High condition
m <- 42 #trial numbers
p1 <- b/m
p2 <- r/m
p3 <- t/m

x <- c(750,833,900,983,1050,1133,1200,1283,1350)

#fit the Weibull model
userlink<-weibull_link(3)#adjust the parameter here, to fit better

#model for blue/ipRGC High condition
model <- glm(p1~x, family=binomial(link=userlink)) 
numxfit <- 999 
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
lengthyfit <- predict(model, data.frame(x=xfit), type="response")

#model for red/control condition
rmodel <- glm(p2~x, family=binomial(link=userlink)) 
numxfit <- 999 
rxfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
rlengthyfit <- predict(rmodel, data.frame(x=rxfit), type="response")

#model for Lightflux High condition
cmodel <- glm(p3~x, family=binomial(link=userlink)) 
numxfit <- 999 
cfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
clengthyfit <- predict(cmodel, data.frame(x=cfit), type="response")

#plot the psychometric function
plot(p1~x, xlab="o", ylab="p",  xlim = c(750, 1350),ylim = c(0,1.0),axes=FALSE,pch=16, cex=3, col="blue")#,col="gray53",)
lines(xfit, lengthyfit, lwd=5, lty=4, col="blue")

par(new=TRUE,cex.axis=1.5)

plot(p2~x,xlab="o", ylab="p", ylim= c(0,1.0),axes=FALSE,pch="o", cex=3, col="chartreuse3")#, col="chartreuse3")
lines(rxfit, rlengthyfit, lwd=5, col="chartreuse3")

#For Experiment 2
#par(new=TRUE,cex.axis=1.5)

#plot(p3~x,xlab="o", ylab="p", ylim= c(0,1.0),axes=FALSE,pch=17, cex=3,col="red")#, col="green"
#lines(cfit, clengthyfit,lwd=5, lty=5,col="red")#, col="green"

axis(1, at=c(750,1050,1350),las=0)
axis(2, at=c(0,0.25,0.5,0.75,1.0),las=0)

#print the parameters (PSE, threshold, slope)
#for blue/ipRGC High condition
OpseResult<-threshold_slope(lengthyfit, xfit, 0.75)
pse1<-threshold_slope(lengthyfit, xfit, 0.5)
pse <- pse1$x_th
OpseResult
pse

#red/control condition
rOpseResult<-threshold_slope(rlengthyfit, rxfit, 0.75)
rpse<-threshold_slope(rlengthyfit, rxfit, 0.5)
rpse <- rpse$x_th
rOpseResult
rpse

#for Lightflux High condition
cOpseResult<-threshold_slope(clengthyfit, cfit, 0.75)
cpse<-threshold_slope(clengthyfit, cfit, 0.5)
cpse <- cpse$x_th
cOpseResult
cpse





